<?php

//////////////////////////////////////////////////////////////
//===========================================================
// webuzo.php
//===========================================================
// SOFTACULOUS 
// Version : 1.1
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       10th Jan 2009
// Time:       21:00 hrs
// Site:       http://www.softaculous.com/ (SOFTACULOUS)
// ----------------------------------------------------------
// Please Read the Terms of use at http://www.softaculous.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Inc.
//===========================================================
//////////////////////////////////////////////////////////////

define('SOFTACULOUS', 1);
define('SOFTMODULEVER', 1);

// To run forever
ignore_user_abort(true);
set_time_limit(0);

//use the Capsule DBAL
use WHMCS\Database\Capsule;

include_once('sdk/webuzo_sdk.php');


function w_fn($f){
	global $conf_webuzo;
	
	if(empty($conf_webuzo['fields'][$f])){
		$r = $f;
	}else{
		$r = $conf_webuzo['fields'][$f];
	}
	
	return $r;	
}

function webuzo_RandStr($length, $special = 0){
	
	global $globals, $softpanel;
	
	$randstack = array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');
	
	$specialchars = array('!', '[', ']', '(', ')', '.', '-', '@');
	
	$randstr = '';

	while(strlen($randstr) < $length){
		
		$randstr .= $randstack[array_rand($randstack)];
		
		if(!empty($special) && strlen($randstr) < $length && (strlen($randstr)%2 == 0)){
			$randstr .= $specialchars[array_rand($specialchars)];
		}
		
	}
	
	return str_shuffle($randstr);

}

// Get a web file with cURL
function webuzo_curl($url, $time = 15, $error = ''){
	
	// Set the curl parameters.
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_VERBOSE, 1);

	// Turn off the server and peer verification (TrustManager Concept).
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $time);
	
	// Check the Header
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	
	// Get response from the server.
	$file = curl_exec($ch);
	
	// Did we get the file ?
	if($file === false && !empty($error)){
		logActivity($error.' cURL Error : '.curl_error($ch));
		return false;
	}
			
	return $file;
	
}//End of function

// Prepare a Script to install
function webuzo_prepare_install($ip, $par, $sid, $license){	

	$waitforlive = 12;
	
	// Try to get the access of the installer by making an API call
	$webuzo = new Webuzo_Admin_SDK('root', $par['password'], $ip);
	
	// Check if live is started
	for($i=1; $i<$waitforlive; $i++){
		$ret = $webuzo->aapi_call('refreshlicense=1');
		
		if(!empty($ret)){
			$live = 1;
			break;
		}
		
		if($waitforlive != $i){
			sleep(5);
		}
	}
	
	if(!empty($live)){
		
		// Do we need to install any Apps ?			
		if(!empty($data['apps'])){
			
			$apps = $webuzo->list_apps();
			
			if(preg_match('/;/is', $data['apps'])){
				$prepareapps = explode(';', $data['apps']);
				$prepareapps = implode(',', $prepareapps);
				$chunk = explode(',', $prepareapps);
			}else{
				$chunk[] = $data['apps'];
			}
			
			foreach($apps as $kt => $vt){
				
				if(in_array($vt['softname'], $chunk)){
					
					$webuzo->curl_timeout = 5;
					
					// Install the APP
					$ret = $webuzo->install_app($vt['aid']);
					
					if(empty($res['done'])){
						logActivity('['.$ip.'] Failed to install app : '.$vt['softname']);
						logActivity('['.$ip.'] Curl Error : '.var_export($webuzo->error, 1));
						logActivity('['.$ip.'] Response Error : '.var_export($res['error'], 1));
					}else{
						logActivity('['.$ip.'] App installed : '.$vt['softname']);
					}
					
				}
				
			}
			
			//print_r($return);
		}
		
		// TODO: Make API call as this will not work !
		//$chk = webuzo_curl('https://'.$ip.':2005/?act=initial&softaculous='.$sid, 2, 'Could not install the script');
		
	}else{
		
		logActivity($ip.' is not running hence can\'t install the script');
		return false;
		
	}
	
	return true;	
}

function webuzo_load_scripts(){

global $webuzo_scripts;
	
	if(!empty($webuzo_scripts)){
		return $webuzo_scripts;
	}
		
	$data = webuzo_curl('http://api.softaculous.com/scripts.php?in=json');
	
	$webuzo_scripts = json_decode($data, true);			
	
	return $webuzo_scripts;
	
}

function webuzo_configure($ip, $par, $license, $sid = '', $ns1 = '' , $ns2 = ''){
	
	$waitforlive = 12;		
	$data = array();
	$data['ip'] = $ip;
	$data['root_password'] = $par['password'];
	
	$data['user'] = $par['customfields'][w_fn('Webuzo User')];
	
	if(empty($data['user'])){
		logActivity('You have not provided any username for Webuzo or Scripts');					
		return false;
	}
	
	$data['email'] = $par['clientsdetails']['email'];
	
	$data['pass'] = webuzo_RandStr(16);
	
	$data['logo'] = $par['customfields'][w_fn('Webuzo Logo')];
	
	$data['language'] = strtolower($par['customfields'][w_fn('Webuzo Language')]);
	
	$data['site_name'] = $par['customfields'][w_fn('Site Name')];
		
	if(empty($data['pass'])){
		logActivity('You have not provided any user password for Webuzo or Scripts');					
		return false;
	}
	
	$data['host'] = (empty($par['domain']) ? $ip : $par['domain']);						
	$data['ns1'] = $ns1;
	$data['ns2'] = $ns2;
	$data['license'] = (empty($license) ? '' :  $license);
	$data['count'] = 1;
	$data['status'] = 'start';
	if(!empty($par['customfields'][w_fn('Apps')])){
		$data['apps'] = trim(strtolower($par['customfields'][w_fn('Apps')]));
	}
	$data['sid'] = $sid;
	$data['is_lock'] = '';
	
	if(!empty($sid)){
	
		// Domain Name
		$data[$sid]['softdomain'] = $data['host']; // OPTIONAL - By Default the primary domain will be used
		
		// The directory is relative to your domain and should not exist. e.g. To install at http://mydomain/dir/ just type dir. To install only in http://mydomain/ leave this empty.
		$data[$sid]['softdirectory'] =  (empty($par['customfields'][w_fn('Directory')]) ? '' : $par['customfields'][w_fn('Directory')]); // OPTIONAL - By default it will be installed in the /public_html folder	
		
		// Admin Username
		$data[$sid]['admin_username'] = (empty($par['customfields'][w_fn('Admin Name')]) ? $data['pass'] : $par['customfields'][w_fn('Admin Name')]);
		
		// Admin Password
		$data[$sid]['admin_pass'] = (empty($par['customfields'][w_fn('Admin Password')]) ? $par['customfields'][w_fn('Webuzo Password')] : $par['customfields'][w_fn('Admin Password')]);
		
		// Admin Email
		$data[$sid]['admin_email'] = $par['clientsdetails']['email'];
		
		// Does the User have any Custom Fields ??
		foreach($conf_webuzo['custom_fields'] as $ck => $cv){
			$data[$sid][$ck] = $par['customfields'][$cv];
		}
	}
	
	$sql = Capsule::select('SELECT `id` FROM `tblcustomfields` WHERE `relid` = :id 
						AND `fieldname` = :fieldname', 
						array(':id' => $par["pid"],
							':fieldname' => w_fn('Webuzo Status')));

	$select = Capsule::select('SELECT value FROM `tblcustomfieldsvalues`
				  WHERE `relid` = :relid
				  AND `fieldid` = :fieldid',
				  array(':relid' => $par["serviceid"],
                                        ':fieldid' => $sql[0]->id));

	try{

		if (count($select)){
			Capsule::update('UPDATE `tblcustomfieldsvalues` 
						SET `value` = :value
						WHERE `relid` = :relid
						AND `fieldid` = :fieldid',
						array(':value' => serialize($data),
							':relid' => $par["serviceid"],
							':fieldid' => $sql[0]->id));
		}else{
			Capsule::insert('INSERT INTO `tblcustomfieldsvalues` 
											SET `value` = :value,
											`relid` = :relid,
											`fieldid` = :fieldid',
											array(':value' => serialize($data),
													':relid' => $par["serviceid"],
													':fieldid' => $sql[0]->id));
		}
	
	}catch (\Exception $e) {
		logActivity("PDO error ".$e->getMessage());
	}

	return true;
}


// Webuzo onapp stars
function webuzo_onapp($par, $action){	
	
	// Include the webuzo_conf.php
	include_once('webuzo_conf.php');
	global $conf_webuzo;	
		
	// Get the product
	$product = Capsule::select('SELECT * FROM `tblproducts` WHERE `id` = :id', 
							array(':id' => $par['packageid']));
	
	foreach($conf_webuzo['product_id'] as $key => $value){
		
		//foreach
		if(trim($product[0]->id) == trim($value)){
				
			// Get the IP
			$test = Capsule::select('SELECT * FROM `tblhosting` WHERE `id` = :id', 
							array(':id' => $par['serviceid']));
			$ip = (array) $test[0];				
			// Include the NOC API
			if(!class_exists('SOFT_NOC')){
				include_once('noc_api.inc');
			}
			
			// Initiate the class with your NOC Account Credentials
			$noc = new SOFT_NOC($conf_webuzo['noc_username'], $conf_webuzo['noc_password']);
			
			switch(trim($action)){
				
				// Create VM
				case 'create':
				
					$server_type = $par['configoptions'][v_fn('Webuzo License Type')];
					
					if(empty($server_type)){
						$server_type = 2;
					}
				
					// Buy / renew a License
					$license_result = $noc->webuzo_buy($ip['assignedips'], '1M', $server_type, $par['clientsdetails']['email'], 1);
					
					// Are we installing any script?
					if(trim(strtolower($par['customfields'][w_fn('Script')])) != 'none'){
					
						$_script = $par['customfields'][w_fn('Script')];					
						$_script = explode(';', $_script);
						
						$apps_to_install = array();
						
						// Is there an application inside ?
						foreach($_script as $kapp => $_app){
							
							$matches = array();
							if(preg_match('/app(\s*?)\:(\s*?)(.*)/is', $_app, $matches)){
								
								unset($_script[$kapp]);
								$apps_to_install[] = trim($matches[3]);
								
							}
						}
						
						if(!empty($apps_to_install)){
							$par['customfields'][w_fn('Apps')] = implode(';', $apps_to_install);
						}
						
						$_script = implode(',', $_script);		
						
						$webuzo_scripts = webuzo_load_scripts();			
									
						// Which Script are we to install ?
						foreach($webuzo_scripts as $key => $value){				
							if(trim(strtolower($value['name'])) == trim(strtolower($_script))){
								$sid = $key;
								break;
							}
						}
										
						// Did we find the Script ?
						if(empty($sid)){				
							logActivity('Could not determine the script to be installed. Please make sure the script name is correct');					
							return false;
							
						}
											
						if($par['customfields'][w_fn('No Webuzo Configuration')] != 'on'){					
							
							// Configure Webuzo 
							webuzo_configure($ip['assignedips'], $par, $license_result['license'], $sid, $ip['ns1'], $ip['ns2']);					
							
						}else{
						
							// Only prepare call						
							webuzo_prepare_install($ip['assignedips'],$par, $sid, $license_result['license']);
						}
					}
					
					break;	
				
				// Terminate VM				
				case 'terminate':
					$result = $noc->webuzo_refund_and_cancel('', $ip['assignedips']);					
					break;
				
				// Suspend VM	
				case 'suspend':
					$result = $noc->webuzo_licenses('', $ip['assignedips']);					
					foreach($result['licenses'] as $kk => $vv){				
						if(trim($vv['ip']) == trim($ip['assignedips'])){
							$license = $vv['license'];
						}					
					}
					$noc->webuzo_removeautorenewal($license);
					break;
				
				//UnsSuspend VM	
				case 'unsuspend':
					$result = $noc->webuzo_licenses('', $ip['assignedips']);					
					foreach($result['licenses'] as $kk => $vv){				
						if(trim($vv['ip']) == trim($ip['assignedips'])){
							$license = $vv['license'];
						}

						// Renew license now
						$current_date = date('Ymd', time());
						if($current_date > $vv['expires']){
				
							$server_type = $par['configoptions'][v_fn('Webuzo License Type')];
							
							if(empty($server_type)){
								$server_type = 2;
							}
							
							$noc->webuzo_buy($vv['ip'], '1M', $server_type, $par['clientsdetails']['email'], 1);	
						}
					}
					$noc->webuzo_addautorenewal($license);
					break;
			}						
		}
	}
}


// Webuzo Virtualizor stars
function webuzo_virtualizor($par, $action){
	
	// Include the webuzo_conf.php
	include_once('webuzo_conf.php');
	global $conf_webuzo;
	
	// Get the OS from the fields set
	$OS = strtolower(trim($par['configoptions'][v_fn('OS')]));
	if(empty($OS)){
		$OS = strtolower(trim($par["customfields"]['OS']));
	}
	
	logActivity('Webuzo Module Virtualizor OS : '.$OS);
	
	if(preg_match('/webuzo/is', $OS)){
					
		// Get the IP
		$test = Capsule::select('SELECT * FROM `tblhosting` WHERE `id` = :id', 
							array(':id' => $par['serviceid']));
		$ip = (array) $test[0];
		// Include the NOC API
		if(!class_exists('SOFT_NOC')){
			include_once('noc_api.inc');
		}
		
		// Initiate the class with your NOC Account Credentials
		$noc = new SOFT_NOC($conf_webuzo['noc_username'], $conf_webuzo['noc_password']);
		
		switch(trim($action)){
			
			// Create VM
			case 'create':
				
				$server_type = $par['configoptions'][v_fn('Webuzo License Type')];
				
				if(empty($server_type)){
					$server_type = 2;
				}
			
				// Buy / renew a License
				$license_result = $noc->webuzo_buy($ip['dedicatedip'], '1M', $server_type, $par['clientsdetails']['email'], 1);
							
				// Are we installing any script?
				if(trim(strtolower($par['customfields'][w_fn('Script')])) != 'none'){
					
					$_script = $par['customfields'][w_fn('Script')];					
					$_script = explode(';', $_script);
					
					$apps_to_install = array();
					
					// Is there an application inside ?
					foreach($_script as $kapp => $_app){
						
						$matches = array();
						if(preg_match('/app(\s*?)\:(\s*?)(.*)/is', $_app, $matches)){
							
							unset($_script[$kapp]);
							$apps_to_install[] = trim($matches[3]);
							
						}
					}
					
					if(!empty($apps_to_install)){
						$par['customfields'][w_fn('Apps')] = implode(';', $apps_to_install);
					}
					
					$_script = implode(',', $_script);		
					
					$webuzo_scripts = webuzo_load_scripts();			
								
					// Which Script are we to install ?
					foreach($webuzo_scripts as $key => $value){				
						if(trim(strtolower($value['name'])) == trim(strtolower($_script))){
							$sid = $key;
							break;
						}
					}
									
					// Did we find the Script ?
					if(empty($sid)){				
						logActivity('Could not determine the script to be installed. Please make sure the script name is correct');					
						return false;						
					}
										
					if($par['customfields'][w_fn('No Webuzo Configuration')] != 'on'){					
						
						// Install LAMP
						webuzo_configure($ip['dedicatedip'], $par, $license_result['license'], $sid, $ip['ns1'], $ip['ns2']);
						
					}else{
					
						// Only prepare call						
						webuzo_prepare_install($ip['dedicatedip'], $par, $sid, $license_result['license']);
					}
				}else{
										
					if($par['customfields'][w_fn('No Webuzo Configuration')] != 'on'){
						
						// Configure Webuzo
						webuzo_configure($ip['dedicatedip'], $par, $license_result['license'], 0, $ip['ns1'], $ip['ns2']);												
					}	

				}
				
				break;

			// Terminate VM				
			case 'terminate':
				$result = $noc->webuzo_refund_and_cancel('', $ip['dedicatedip']);					
				break;
			
			// Suspend VM	
			case 'suspend':
				$result = $noc->webuzo_licenses('', $ip['dedicatedip']);					
				foreach($result['licenses'] as $kk => $vv){				
					if(trim($vv['ip']) == trim($ip['dedicatedip'])){
						$license = $vv['license'];
					}					
				}
				$noc->webuzo_removeautorenewal($license);
				break;
			
			//UnsSuspend VM	
			case 'unsuspend':
				$result = $noc->webuzo_licenses('', $ip['dedicatedip']);					
				foreach($result['licenses'] as $kk => $vv){				
					if(trim($vv['ip']) == trim($ip['dedicatedip'])){
						$license = $vv['license'];
					}
					
					// Renew license now
					$current_date = date('Ymd', time());
					if($current_date > $vv['expires']){
				
						$server_type = $par['configoptions'][v_fn('Webuzo License Type')];
						
						if(empty($server_type)){
							$server_type = 2;
						}
						
						$noc->webuzo_buy($vv['ip'], '1M', $server_type, $par['clientsdetails']['email'], 1);	
					}
				}
				$noc->webuzo_addautorenewal($license);
				break;
		}						
		
	}
}


function webuzo_solusvm($par, $action){
	
	// Include the webuzo_conf.php
	include_once('webuzo_conf.php');
	
	global $conf_webuzo;

	if(preg_match('/webuzo/is', strtolower($par['configoption6']))){			
			
		// Get the IP
		$test = Capsule::select('SELECT * FROM `tblhosting` WHERE `id` = :id', 
							array(':id' => $par['serviceid']));
		$ip = (array) $test[0];	

		// Include the NOC API
		if(!class_exists('SOFT_NOC')){
			include_once('noc_api.inc');
		}
		
		// Initiate the class with your NOC Account Credentials
		$noc = new SOFT_NOC($conf_webuzo['noc_username'], $conf_webuzo['noc_password']);
		
		switch(trim($action)){
			
			// Create VM
			case 'create':
				
				$server_type = $par['configoptions'][v_fn('Webuzo License Type')];
				
				if(empty($server_type)){
					$server_type = 2;
				}
				
				// Buy / renew a License
				$license_result = $noc->webuzo_buy($ip['dedicatedip'], '1M', $server_type, $par['clientsdetails']['email'], 1);	
							
				// Are we installing any script?
				if(trim(strtolower($par['customfields'][w_fn('Script')])) != 'none'){
					
					$_script = $par['customfields'][w_fn('Script')];					
					$_script = explode(';', $_script);
					
					$apps_to_install = array();
					
					// Is there an application inside ?
					foreach($_script as $kapp => $_app){
						
						$matches = array();
						if(preg_match('/app(\s*?)\:(\s*?)(.*)/is', $_app, $matches)){
							
							unset($_script[$kapp]);
							$apps_to_install[] = trim($matches[3]);
							
						}
					}
					
					if(!empty($apps_to_install)){
						$par['customfields'][w_fn('Apps')] = implode(';', $apps_to_install);
					}
					
					$_script = implode(',', $_script);		
					
					$webuzo_scripts = webuzo_load_scripts();			
								
					// Which Script are we to install ?
					foreach($webuzo_scripts as $key => $value){				
						if(trim(strtolower($value['name'])) == trim(strtolower($_script))){
							$sid = $key;
							break;
						}
					}
									
					// Did we find the Script ?
					if(empty($sid)){				
						logActivity('Could not determine the script to be installed. Please make sure the script name is correct');					
						return false;						
					}
										
					if($par['customfields'][w_fn('No Webuzo Configuration')] != 'on'){					
						
						// Configure Webuzo 
						webuzo_configure($ip['dedicatedip'], $par, $license_result['license'], $sid, $ip['ns1'], $ip['ns2']);					
						
					}else{
					
						// Only prepare call						
						webuzo_prepare_install($ip['dedicatedip'], $par, $sid, $license_result['license']);
						
					}
					
				}else{
										
					if($par['customfields'][w_fn('No Webuzo Configuration')] != 'on'){
						
						// Configure Webuzo 
						webuzo_configure($ip['dedicatedip'], $par, $license_result['license'], 0, $ip['ns1'], $ip['ns2']);												
					}
											
				}
			
				break;
						
			// Terminate VM				
			case 'terminate':
				$result = $noc->webuzo_refund_and_cancel('', $ip['dedicatedip']);					
				break;
			
			// Suspend VM	
			case 'suspend':
				$result = $noc->webuzo_licenses('', $ip['dedicatedip']);					
				foreach($result['licenses'] as $kk => $vv){				
					if(trim($vv['ip']) == trim($ip['dedicatedip'])){
						$license = $vv['license'];
					}					
				}
				$noc->webuzo_removeautorenewal($license);
				break;
			
			//UnsSuspend VM	
			case 'unsuspend':
				$result = $noc->webuzo_licenses('', $ip['dedicatedip']);					
				foreach($result['licenses'] as $kk => $vv){				
					if(trim($vv['ip']) == trim($ip['dedicatedip'])){
						$license = $vv['license'];
					}

					// Renew license now
					$current_date = date('Ymd', time());
					if($current_date > $vv['expires']){
				
						$server_type = $par['configoptions'][v_fn('Webuzo License Type')];
						
						if(empty($server_type)){
							$server_type = 2;
						}
						
						$noc->webuzo_buy($vv['ip'], '1M', $server_type, $par['clientsdetails']['email'], 1);	
					}
				}
				$noc->webuzo_addautorenewal($license);
				break;
		}						
		
	}
}
	

function webuzo_create($params){
	
	$par = $params['params'];
	
	// For OnAPP
	if(strtolower($par['moduletype']) == 'onapp'){
		webuzo_onapp($par, 'create');
		return true;
	}
	
	// For Virtualizor
	if(strtolower($par['moduletype']) == 'virtualizor'){
		webuzo_virtualizor($par, 'create');
		return true;
	}	
	
	// For SolusVM
	if(strtolower($par['moduletype']) == 'solusvmpro'){		
		webuzo_solusvm($par, 'create');
		return true;
	}

}

function webuzo_terminate($params){

	$par = $params['params'];		
	
	$query = Capsule::select('SELECT `id` FROM `tblcustomfields` WHERE `relid` = :id 
								AND `fieldname` = :fieldname', 
								array(':id' => $par["pid"],
									':fieldname' => w_fn('Webuzo Status')));
	$res = (array) $query[0];
	
	try{
	
		Capsule::update('UPDATE `tblcustomfieldsvalues` 
				SET `value` = "" 
				WHERE `relid` = :relid 
				AND `fieldid` = :fieldid',
				array(':relid' => $par["serviceid"],
					':fieldid' => $res[id]));
	
	}catch (\Exception $e) {
		logActivity("PDO error ".$e->getMessage());
	}			
		
	
	// For OnAPP
	if(strtolower($par['moduletype']) == 'onapp'){
		webuzo_onapp($par, 'terminate');
		return $params;
	}	
	
	// For Virtualizor
	if(strtolower($par['moduletype']) == 'virtualizor'){
		webuzo_virtualizor($par, 'terminate');
		return $params;
	}
	
	// For SolusVM
	if(strtolower($par['moduletype']) == 'solusvmpro'){
		webuzo_solusvm($par, 'terminate');
		return $params;
	}
}

function webuzo_suspend($params){

	$par = $params['params'];		
	
	// For OnAPP
	if(strtolower($par['moduletype']) == 'onapp'){
		webuzo_onapp($par, 'suspend');
		return true;
	}
	
	// For Virtualizor
	if(strtolower($par['moduletype']) == 'virtualizor'){
		webuzo_virtualizor($par, 'suspend');
		return true;
	}	
	
	// For SolusVM
	if(strtolower($par['moduletype']) == 'solusvmpro'){
		webuzo_solusvm($par, 'suspend');
		return true;
	}
}

function webuzo_unsuspend($params){

	$par = $params['params'];		
	
	// For OnAPP
	if(strtolower($par['moduletype']) == 'onapp'){
		webuzo_onapp($par, 'unsuspend');
		return true;
	}
	
	// For Virtualizor
	if(strtolower($par['moduletype']) == 'virtualizor'){
		webuzo_virtualizor($par, 'unsuspend');
		return true;
	}
	
	// For SolusVM
	if(strtolower($par['moduletype']) == 'solusvmpro'){
		webuzo_solusvm($par, 'unsuspend');
		return true;
	}
	
}

add_hook("AfterModuleCreate", 1, "webuzo_create");

add_hook("PreModuleTerminate", 1,"webuzo_terminate");

add_hook("AfterModuleSuspend", 1,"webuzo_suspend");

add_hook("AfterModuleUnsuspend", 1,"webuzo_unsuspend");
