<?php

define('SOFTACULOUS', 1);
define('SOFTMODULEVER', 1);

// To run forever
ignore_user_abort(true);
set_time_limit(0);

// Include the init file to be able to use Capsule class
require_once(dirname(dirname(dirname(__FILE__))).'/init.php');

//use the Capsule DBAL
use WHMCS\Database\Capsule;
include_once(__DIR__ .'/sdk/sdk.php');
include_once(__DIR__ .'/sdk/webuzo_sdk.php');

/**
* Update query
* 
* @param        array  $data Actual data
* @param        String $relid relid 
* @param        String $fieldid fieldid
* @param        String $final_done Complet proccess and append the data with 1|
* @return       boolean
*/	
function webuzo_update_q($data, $relid , $fieldid , $done = ''){
	
	if(!empty($done)){
		
		if($done == '1'){
		
			$status = (empty($data['status'])) ? "Server could not be configured due to some reason. Please contact Sales." : " ";
			
			// Mail message
			$message = "Hi,
	
Your Webuzo installed VPS is up and ready to use.
Here is the status of your VPS : ".$data['status']."

".$status ."

Regards,
Webuzo";
			
			// Mail
			@mail($data['email'], 'Status of your Webuzo VPS '.$data['ip'].' created from WHMCS', $message);
		
		}
	
		// End for search 
		$output = '1|'.serialize($data);
		
	}else{
		
		$output = serialize($data);
		
	}
	
	Capsule::update('UPDATE `tblcustomfieldsvalues` 
		SET `value` = :value 
		WHERE `relid` = :relid 
		AND `fieldid` = :fieldid',
		array(':value' => $output,
			':relid' => $relid,
			':fieldid' => $fieldid)
	);
	
	return true;
	
}//End of function

function webuzo_log($data){
	echo $data."\n";
}

///////////////////////////////////
// Code Start !
///////////////////////////////////

// Get the id of webuzo custom field
$query = Capsule::select('SELECT `id` FROM `tblcustomfields` 
			WHERE `fieldname` = :fieldname', 
			array(':fieldname' => 'Webuzo Status')
		);

$t_res = array();

foreach($query as $k => $v){
	$t_res[] = $v->id;
}

//print_r($t_res);

$t_res = empty($t_res) ? array(-1) : $t_res;

// Get the data of webuzo custom field
$placeholders = str_repeat ('?, ',  count ($t_res) - 1) . '?';
$query = Capsule::select('SELECT * FROM `tblcustomfieldsvalues` 
			WHERE `fieldid` IN ('.$placeholders.') 
			AND `value` NOT LIKE "1|%"',
		$t_res);

// If there is anything we can do !
if(count($query) <= 0){
	webuzo_log("No records found. Exiting ! : ".count($record));
	exit(0);
}
	
for($i = 1; $i <= count($query); $i++){
	$record[$i] = (array) $query[$i];
	
	// If record is empty, vps is terminated
	if(empty($record[$i]['value'])){
		unset($record[$i]);
	}

}

webuzo_log("Number of records found : ".count($record));
//print_r($record);

// Check if live
foreach($record as $k => $v){
	
	$c_data = unserialize($v['value']);
	//print_r($c_data);
	
	webuzo_log("\n".'['.$c_data['ip'].'] Started working with this record');
	
	// We enter if there is NO Lock 
	// OR
	// If there is a lock which is more than 10 minutes
	// and attempt is not more then 30
	if( ! (empty($c_data['is_lock']) || round((time() - $c_data['is_lock'])/60) < 10) ){
		webuzo_log('['.$c_data['ip'].'] Skipping due to Lock');
		continue;
	}
	
	// We still need to be sure that no other process is checking for this particular server
	// Hence we get the data of this row again
	$query = Capsule::select('SELECT * FROM `tblcustomfieldsvalues` WHERE `fieldid` = :fieldid 
				AND `relid` = :relid 
				AND `value` NOT LIKE "1|%"', 
				array(':fieldid' => $v['fieldid'],
					':relid' => $v['relid']));
	$rest = (array) $query[0];

	if(count($query) < 1){
		continue;
	}
		
	$data = unserialize($rest['value']);	
	//print_r($data);
	
	// Again check the status
	if( ! (empty($data['is_lock']) || round((time() - $data['is_lock'])/60) < 10) ){	
		webuzo_log('['.$data['ip'].'] Skipping due to Lock 2nd Check');
		continue;
	}
	
	// Just for safety
	if($data['count'] > 30 || empty($data['count'])){
		
		// End cron
		$data['count'] = 0;
		
		// Call update query function
		webuzo_update_q($data, $rest['relid'], $rest['fieldid'], 2);			
		webuzo_log('['.$data['ip'].'] Skipping due to 30 Attempts check');
		
		continue;
		
	}
	
	// Lock and update so that no other process tries this
	$data['is_lock'] = time();
	
	// Call update query function
	webuzo_update_q($data, $rest['relid'] , $rest['fieldid']);
	
	// Just a status change on startup
	$data['status'] = 'Running';
	
	// Add to the count
	$data['count'] = $data['count'] + 1;
	
	webuzo_log('['.$data['ip'].'] Trying to connect. Attempt : '.$data['count']);
	
	// Try to get the access of the installer by making an API call
	$webuzo = new Webuzo_Admin_SDK('root', $data['root_password'], $data['ip']);
	$ret = $webuzo->aapi_call('refreshlicense=1');
	
	// Ok, we got the installer
	if(empty($ret)){
		
		webuzo_log('['.$data['ip'].'] No response !');
		
	}else{
		
		webuzo_log('['.$data['ip'].'] Got response from server');
		
		// End cron
		$data['count'] = 0;
		
		// Change status
		$data['status'] = 'Working';
		
		// Call update query function
		webuzo_update_q($data, $rest['relid'] , $rest['fieldid']);
		webuzo_log('['.$data['ip'].'] Configuring new VPS');
		
		// Do we need to install any Apps ?			
		if(!empty($data['apps'])){
			
			$apps = $webuzo->list_apps();
			
			if(preg_match('/;/is', $data['apps'])){
				$prepareapps = explode(';', $data['apps']);
				$prepareapps = implode(',', $prepareapps);
				$chunk = explode(',', $prepareapps);
			}else{
				$chunk[] = $data['apps'];
			}
			
			foreach($apps as $kt => $vt){
				
				if(in_array($vt['softname'], $chunk)){
					
					$webuzo->curl_timeout = 900;
					
					// Install the APP
					$ret = $webuzo->install_app($vt['aid']);
					
					if(empty($res['done'])){
						webuzo_log('['.$data['ip'].'] Failed to install app : '.$vt['softname']);
						print_r($webuzo->error);
						echo file_get_contents('php://temp');
					}else{
						webuzo_log('['.$data['ip'].'] App installed : '.$vt['softname']);
					}
					
				}
				
			}
			
			//print_r($return);
		}
		
		// Prepare call for logo / sitename / language
		webuzo_log('['.$data['ip'].'] Setting logo, language, name');
		$webuzo->set_panel_config($data['site_name'], $data['logo'], $data['logo']);
		
		// Change hostname before creating user			
		$ret = $webuzo->set_panel_config($data['ip'], 'server-'.str_replace('www.', '', $data['host']));
		
		if(empty($ret['done'])){
			webuzo_log('['.$data['ip'].'] Failed to set hostname : '.var_export($ret, 1));
		}else{
			webuzo_log('['.$data['ip'].'] Hostname changes successful');
		}
		
		webuzo_log('['.$data['ip'].'] Creating default user');
		
		// First we need to create user to install script
		$res = $webuzo->create_user($data['user'], $data['host'], $data['pass'], $data['email']);
		//$res = unserialize($res);
		
		// Was it successful ?
		if(!empty($res['done'])){
			
			webuzo_log('['.$data['ip'].'] Default User created');
			
			// Do we need to install a Script - We use the AUTO INSTALL method
			if(!empty($data['sid'])){
				
				// Lets ensure the license is updated !			
				webuzo_log('['.$data['ip'].'] Updating Softaculous License !');
				
				$soft_url = str_replace('index.php', 'softaculous/index.php?refreshlicense=1&api=json', $webuzo->login);
				//webuzo_log('['.$data['ip'].'] '.$soft_url);
				
				$resp = $webuzo->curl($soft_url);
				
				webuzo_log('['.$data['ip'].'] Installing Script '.$data['sid']);

				// Init Softaculous SDK
				$new = new Softaculous_SDK();
				$new->login = 'https://'.rawurlencode($data['user']).':'.rawurlencode($data['pass']).'@'.$data['ip'].':2003/softaculous/index.php';
				
				// Install
				$resp = $new->install($data['sid'], $data[$data['sid']]);
				
				// Unserialize
				$res = $new->format_decode($resp);
				
				// Was there any error ?
				if(!empty($res['done'])){
										
					// Change status
					$data['status'] = 'Webuzo Configuration and Script installation done successfully';
					webuzo_log('['.$data['ip'].'] '.$data['status']);
				
				// Error
				}else{
					
					// Change status
					$data['status'] = 'Error : Webuzo configured but error occured while installing Script : '.implode('', $res['error']);
					webuzo_log('['.$data['ip'].'] '.$data['status']);
					
				}
				
			}else{
								
				// Change status
				$data['status'] = 'Webuzo Configured successfully';
				webuzo_log('['.$data['ip'].'] '.$data['status']);
				
			}
		
		// Looks like there was an error
		}else{	
		
			// Change status
			$data['status'] = 'Error: Some error occurred while creating default user : '.$data['user'].' - '.implode(',', $res['error']);
			webuzo_log('['.$data['ip'].'] '.$data['status']);
			print_r($res);
		
		}
		
	}// End of install.php IF
	
	// Check count is not more then maximum attempt ?
	if(!empty($data['count']) && $data['count'] >= 31 ){
		
		$data['status'] = 'Error: Too much time for VPS to come live';
		webuzo_log('['.$data['ip'].'] '.$data['status']);
		
		// End cron 
		$data['count'] = 0;
		
	}
	
	// Free the lock
	$data['is_lock'] = 0;
	
	// Check the counter if complete then append with 1|
	if(empty($data['count'])){
		
		// Call update query function
		webuzo_update_q($data, $rest['relid'] , $rest['fieldid'] , 1);
	
	// Should we mail the entire status?
	}else{
		
		// Call update query function
		webuzo_update_q($data, $rest['relid'] , $rest['fieldid']);
		
	}
		
	webuzo_log('['.$data['ip'].'] '.$data['status']);
	
}

webuzo_log('Finished Cron');

