<?php

class SOFT_NOC{

	var $nocname = 'username';
	var $nocpass = 'password';
	var $softaculous = 'http://www.softaculous.com/noc';
	var $error = array();
	var $params = array();
	var $response = array();
	var $raw_response;
	
	function SOFT_NOC($nocname = '', $nocpass = '', $url = ''){
		
		if(!empty($nocname)){
			$this->nocname = $nocname;
		}
		
		if(!empty($nocpass)){
			$this->nocpass = $nocpass;
		}
		
		if(!empty($url)){
			$this->softaculous = $url;
		}
		
	}
	
	function req() {
		
		$url = $this->softaculous.'?nocname='.rawurlencode($this->nocname).'&nocpass='.rawurlencode($this->nocpass);
		
		foreach($this->params as $k => $v){
			$url .= '&'.$k.'='.rawurlencode($v);
		}
		//echo $url.'<br>';
		
		// Set the curl parameters.
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
	
		// Turn off the server and peer verification (TrustManager Concept).
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	
		// Get response from the server.
		$this->raw_response = curl_exec($ch);
		
		if(!$this->raw_response) {
			$this->error[] = 'There was some error in connecting to Softaculous. This may be because of no internet connectivity at your end.';
			return false;
		}
	
		// Extract the response details.
		$this->response = unserialize($this->raw_response);
		
		if(empty($this->response['error'])){
			unset($this->response['error']);
			return $this->response;
		}else{
			$this->error = array_merge($this->error, $this->response['error']);
			return false;
		}
		
	}
	
	/*===========================================================================
		@@ function buy - To Buy or Renew a License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $ip - The IP of the license to be Purchased or Renewed
		2) $toadd - Time to extend. Valid extension e.g. 
					- '1M' will extend by one months
					- '8M' will extend by eight months
					- '1Y' will extend by One year
		3) $servertype - 1 for Dedicated and 2 for VPS
		4) $authemail - When a new license is purchased an Authorisation email
						is required to verify the owner of the License or for 
						reminders when the license is expiring. This is not 
						required in case of renewals
		5) $autorenew - To be renewed Automatically before expiry.
						Values - 1 for true
								 2 for false
						Emails will be sent when renewed.
	===========================================================================*/
	
	function buy($ip, $toadd, $servertype, $authemail, $autorenew){
		$this->params['ca'] = 'buy';
		$this->params['purchase'] = 1;
		$this->params['ips'] = $ip;
		$this->params['toadd'] = $toadd;
		$this->params['servertype'] = $servertype;
		$this->params['authemail'] = $authemail;
		$this->params['autorenew'] = $autorenew;
		return $this->req();
	}
	
		
	/*===========================================================================
		@@ function refund - reverses a transaction @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $actid - The Action ID for which you want to claim refund
		
		NOTE: A refund can be claimed only within 7 days of buying/renewing the
			  license
	===========================================================================*/
	function refund($actid){
		$this->params['ca'] = 'refund';
		$this->params['actid'] = $actid;
		return $this->req();
	}
	
		
	/*===========================================================================
		@@ function licenses - gets a list of licenses @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY to get the details of that 
				  particular License
		2) $ip - (Optional) The Primary IP of a License to get the details of 
				  that particular License
		3) $expiry - (Optional) To get a List of License that are expiring.
					 Valid Options - 1 , 2 , 3 . Explanation is as follows:
					 $expiry = 1; (All Expired License in your account)
					 $expiry = 2; (Expiring in 7 Days)
					 $expiry = 3; (Expiring in 15 Days)		
		4) $start - (Optional) The starting key to return from. e.g.
					If the result is 500 licenses and you wanted only from 
					the 100th one then specify 99		
		5) $len - (Optional) The length to return from the start. e.g.
					If the result is 500 licenses and you wanted only from 
					the 200 items after the 100th one then specify 
					$start = 99 and $len = 200					
		6) $email - (Optional) The authorised email of the user for which 
					you want to get the list of licenses.
				  
		NOTE: $key, $ip, $expiry, $start, $len (i.e. All Paras) are Optional
			  When nothing is specified a list of all your license will 
			  be returned.
	===========================================================================*/
	function licenses($key = '', $ip = '', $expiry = '', $start = 0, $len = 1000000, $email = ''){
		$this->params['ca'] = 'licenses';
		$this->params['lickey'] = $key;
		$this->params['ips'] = $ip;
		$this->params['expiry'] = $expiry;
		$this->params['start'] = $start;
		$this->params['len'] = $len;
		$this->params['email'] = $email;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function cancel - remove license and its auto renewal @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY
		2) $ip - (Optional) The Primary IP of the License
				  
		NOTE: 1) Either of $ip, $key needs to be scpeified
			  2) A cancel will not be allowed if you have a license expiring 
			  	after MORE than a MONTH.
			  3) Also a refund is not made when you cancel a license. You must 
			    first claim the refund using the refund() API			  
	===========================================================================*/
	function cancel($key = '', $ip = ''){
		$this->params['ca'] = 'cancel';
		$this->params['lickey'] = $key;
		$this->params['licip'] = $ip;
		$this->params['cancel_license'] = 1;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function refund_and_cancel - refund license and then remove license and its auto renewal @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY
		2) $ip - (Optional) The Primary IP of the License
				  
		NOTE: 1) Either of $ip, $key needs to be scpeified
			  2) A cancel will not be allowed if you have a license expiring 
			  	after MORE than a MONTH.
			  3) We will try to refund you if the license is purchased less than 7 days ago. And then we will cancel the license.
			  
	===========================================================================*/
	function refund_and_cancel($key = '', $ip = ''){
		if(!empty($ip)){
			// Search for a license
			$lic = $this->licenses('', $ip);
			// No licenes with this IP
			if(empty($lic['licenses'])){
				$this->error[] = 'No Licenses found.';
				return false;
			}
			$my_lic = current(current($lic));
			$key = $my_lic['license'];
		}
		
		// No key to search for the logs or to cancel
		if(empty($key)){
			$this->error[] = 'Please provide a License Key or a Valid IP.';
			return false;
		}
		
		// Lets get the logs
		$logs = $this->licenselogs($key);
		
		// Did we get any logs ?
		if(!empty($logs['actions'])){
			foreach($logs['actions'] as $k => $v){
				// Is it a valid transaction ?
				if($v['action'] != 'renew' && $v['action'] != 'new') continue;
				// Is it purchased within last 7 days
				if((time() - $v['time'])/(24*60*60) < 7){
					$this->refund($v['actid']);
				}
			}
		}
		
		// Cancel the license
		return $this->cancel($key);
	}
	
	
	/*===========================================================================
		@@ function editips - Edit the IPs of a License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $lid - The License ID (NOT the license key) e.g. lid could be 1000
		2) $ips - The list of IPs of the same VPS / Server. The first IP you 
				  enter will be the primary IP Address of the License. You can 
				  enter upto a maximum of 8 IP Address per license.
				  
		NOTE: Either of $ip, $key needs to be scpeified
	===========================================================================*/
	function editips($lid, $ips){
		$this->params['ca'] = 'showlicense';
		$this->params['lid'] = $lid;
		$this->params['ips[]'] = $ips;
		$this->params['editlicense'] = 1;
		return $this->req();
	}
		
		
	/*===========================================================================
		@@ function licenselogs - Action Logs of a License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY
		2) $limit - The number of action logs to be retrieved
		NOTE: The logs are returned in DESCENDING ORDER, meaning the latest logs 
			  will be return first.
	===========================================================================*/
	function licenselogs($key, $limit = 0){
		$this->params['ca'] = 'licenselogs';
		$this->params['key'] = $key;
		if(!empty($limit)){
			$this->params['limit'] = $limit;
		}
		return $this->req();
	}
		
		
	/*===========================================================================
		@@ function autorenewals - List the Auto Renewing Licenses @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY to get the details of that 
				  particular License
		2) $ip - (Optional) The Primary IP of a License to get the details of 
				  that particular License
		3) $start - (Optional) The starting key to return from. e.g.
					If the result is 500 licenses and you wanted only from 
					the 100th one then specify 99		
		4) $len - (Optional) The length to return from the start. e.g.
					If the result is 500 licenses and you wanted only from 
					the 200 items after the 100th one then specify 
					$start = 99 and $len = 200
				  
		NOTE: $key, $ip, $expiry, $start, $len (i.e. All Paras) are Optional
			  When nothing is specified a list of all your license will 
			  be returned.
	===========================================================================*/
	function autorenewals($key = '', $ip = '', $start = 0, $len = 1000000){
		$this->params['ca'] = 'renewals';
		$this->params['lickey'] = $key;
		$this->params['ips'] = $ip;
		$this->params['start'] = $start;
		$this->params['len'] = $len;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function addautorenewal - Add Auto Renewals @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY to get the details of that 
				  particular License
	===========================================================================*/
	function addautorenewal($key = ''){
		$this->params['ca'] = 'renewals';
		$this->params['addrenewal'] = 1;
		$this->params['lickey'] = $key;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function removeautorenewal - Remove Auto Renewals @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY to get the details of that 
				  particular License
	===========================================================================*/
	function removeautorenewal($key = ''){
		$this->params['ca'] = 'renewals';
		$this->params['cancelrenewal'] = 1;
		$this->params['lickey'] = $key;
		return $this->req();
	}
	
	
	////////////////////
	// WEBUZO Functions
	////////////////////
		
	/*===========================================================================
		@@ function webuzo_buy - To Buy or Renew a License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $ip - The IP of the license to be Purchased or Renewed
		2) $toadd - Time to extend. Valid extension e.g. 
					- '1M' will extend by one months
					- '8M' will extend by eight months
					- '1Y' will extend by One year
		3) $servertype - 1 for Dedicated and 2 for VPS
		4) $authemail - When a new license is purchased an Authorisation email
						is required to verify the owner of the License or for 
						reminders when the license is expiring. This is not 
						required in case of renewals
		5) $autorenew - To be renewed Automatically before expiry.
						Values - 1 for true
								 2 for false
						Emails will be sent when renewed.
	===========================================================================*/
	
	function webuzo_buy($ip, $toadd, $servertype, $authemail, $autorenew){
		$this->params['ca'] = 'webuzo_buy';
		$this->params['purchase'] = 1;
		$this->params['ips'] = $ip;
		$this->params['toadd'] = $toadd;
		$this->params['servertype'] = $servertype;
		$this->params['authemail'] = $authemail;
		$this->params['autorenew'] = $autorenew;
		return $this->req();
	}
	
		
	/*===========================================================================
		@@ function webuzo_refund - reverses a transaction @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $actid - The Action ID for which you want to claim refund
		
		NOTE: A refund can be claimed only within 7 days of buying/renewing the
			  license
	===========================================================================*/
	function webuzo_refund($actid){
		$this->params['ca'] = 'webuzo_refund';
		$this->params['actid'] = $actid;
		return $this->req();
	}
	
		
	/*===========================================================================
		@@ function webuzo_licenses - gets a list of licenses @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY to get the details of that 
				  particular License
		2) $ip - (Optional) The Primary IP of a License to get the details of 
				  that particular License
		3) $expiry - (Optional) To get a List of License that are expiring.
					 Valid Options - 1 , 2 , 3 . Explanation is as follows:
					 $expiry = 1; (All Expired License in your account)
					 $expiry = 2; (Expiring in 7 Days)
					 $expiry = 3; (Expiring in 15 Days)		
		4) $start - (Optional) The starting key to return from. e.g.
					If the result is 500 licenses and you wanted only from 
					the 100th one then specify 99		
		5) $len - (Optional) The length to return from the start. e.g.
					If the result is 500 licenses and you wanted only from 
					the 200 items after the 100th one then specify 
					$start = 99 and $len = 200					
		6) $email - (Optional) The authorised email of the user for which 
					you want to get the list of licenses.
				  
		NOTE: $key, $ip, $expiry, $start, $len (i.e. All Paras) are Optional
			  When nothing is specified a list of all your license will 
			  be returned.
	===========================================================================*/
	function webuzo_licenses($key = '', $ip = '', $expiry = '', $start = 0, $len = 1000000, $email = ''){
		$this->params['ca'] = 'webuzo';
		$this->params['lickey'] = $key;
		$this->params['ips'] = $ip;
		$this->params['expiry'] = $expiry;
		$this->params['start'] = $start;
		$this->params['len'] = $len;
		$this->params['email'] = $email;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function webuzo_cancel - remove license and its auto renewal @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY
		2) $ip - (Optional) The Primary IP of the License
				  
		NOTE: 1) Either of $ip, $key needs to be specified
			  2) A cancel will not be allowed if you have a license expiring 
			  	after MORE than a MONTH.
			  3) Also a refund is not made when you cancel a license. You must 
			    first claim the refund using the refund() API			  
	===========================================================================*/
	function webuzo_cancel($key = '', $ip = ''){
		$this->params['ca'] = 'webuzo_cancel';
		$this->params['lickey'] = $key;
		$this->params['licip'] = $ip;
		$this->params['cancel_license'] = 1;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function webuzo_refund_and_cancel - refund webuzo license and then remove webuzo license and its auto renewal @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY
		2) $ip - (Optional) The Primary IP of the License
				  
		NOTE: 1) Either of $ip, $key needs to be scpeified
			  2) A cancel will not be allowed if you have a license expiring 
			  	after MORE than a MONTH.
			  3) We will try to refund you if the license is purchased less than 7 days ago. And then we will cancel the license.
			  
	===========================================================================*/
	function webuzo_refund_and_cancel($key = '', $ip = ''){
		if(!empty($ip)){
			// Search for a license
			$lic = $this->webuzo_licenses('', $ip);
			// No licenes with this IP
			if(empty($lic['licenses'])){
				$this->error[] = 'No Licenses found.';
				return false;
			}
			$my_lic = current(current($lic));
			$key = $my_lic['license'];
		}
		
		// No key to search for the logs or to cancel
		if(empty($key)){
			$this->error[] = 'Please provide a License Key or a Valid IP.';
			return false;
		}
		
		// Lets get the logs
		$logs = $this->webuzo_licenselogs($key);
		
		// Did we get any logs ?
		if(!empty($logs['actions'])){
			foreach($logs['actions'] as $k => $v){
				// Is it a valid transaction ?
				if($v['action'] != 'renew' && $v['action'] != 'new') continue;
				// Is it purchased within last 7 days
				if((time() - $v['time'])/(24*60*60) < 7){
					$this->webuzo_refund($v['actid']);
				}
			}
		}
		
		// Cancel the license
		return $this->webuzo_cancel($key);
	}
	
	
	/*===========================================================================
		@@ function webuzo_editips - Edit the IPs of a License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $lid - The License ID (NOT the license key) e.g. lid could be 1000
		2) $ips - The IP (SINGLE IP ONLY) of the VPS / Server. Unlike Softaculous 
				  only one IP is allowed here
				  
		NOTE: Either of $ip, $key needs to be scpeified
	===========================================================================*/
	function webuzo_editips($lid, $ips){
		$this->params['ca'] = 'webuzolicense';
		$this->params['lid'] = $lid;
		$this->params['ips'] = $ips;
		$this->params['editlicense'] = 1;
		return $this->req();
	}
		
		
	/*===========================================================================
		@@ function webuzo_licenselogs - Action Logs of a License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY
		2) $limit - The number of action logs to be retrieved
		NOTE: The logs are returned in DESCENDING ORDER, meaning the latest logs 
			  will be return first.
	===========================================================================*/
	function webuzo_licenselogs($key, $limit = 0){
		$this->params['ca'] = 'webuzo_licenselogs';
		$this->params['key'] = $key;
		if(!empty($limit)){
			$this->params['limit'] = $limit;
		}
		return $this->req();
	}
		
		
	/*===========================================================================
		@@ function webuzo_autorenewals - List the Auto Renewing Licenses @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY to get the details of that 
				  particular License
		2) $ip - (Optional) The Primary IP of a License to get the details of 
				  that particular License
		3) $start - (Optional) The starting key to return from. e.g.
					If the result is 500 licenses and you wanted only from 
					the 100th one then specify 99		
		4) $len - (Optional) The length to return from the start. e.g.
					If the result is 500 licenses and you wanted only from 
					the 200 items after the 100th one then specify 
					$start = 99 and $len = 200
				  
		NOTE: $key, $ip, $expiry, $start, $len (i.e. All Paras) are Optional
			  When nothing is specified a list of all your license will 
			  be returned.
	===========================================================================*/
	function webuzo_autorenewals($key = '', $ip = '', $start = 0, $len = 1000000){
		$this->params['ca'] = 'webuzo_renewals';
		$this->params['lickey'] = $key;
		$this->params['ips'] = $ip;
		$this->params['start'] = $start;
		$this->params['len'] = $len;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function webuzo_addautorenewal - Add Auto Renewals @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY that has to be added to Auto Renewal
	===========================================================================*/
	function webuzo_addautorenewal($key = ''){
		$this->params['ca'] = 'webuzo_renewals';
		$this->params['addrenewal'] = 1;
		$this->params['lickey'] = $key;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function webuzo_removeautorenewal - Remove Auto Renewals @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY that has to be removed from Auto Renewal
	===========================================================================*/
	function webuzo_removeautorenewal($key = ''){
		$this->params['ca'] = 'webuzo_renewals';
		$this->params['cancelrenewal'] = 1;
		$this->params['lickey'] = $key;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function webuzotrial - Webuzo Trial @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $ip - The IP that has to be licensed with a TRIAL License
		2) $servertype - Whether its a VPS or a Dedicated Server License
	===========================================================================*/
	function webuzotrial($ip, $servertype){
		$this->params['ca'] = 'webuzotrial';
		$this->params['ips'] = $ip;
		$this->params['type'] = $servertype;
		$this->params['gettrial'] = 1;
		return $this->req();
	}
	
	//////////////////////////
	// Virtualizor Functions
	//////////////////////////
		
	/*===========================================================================
		@@ function virt_buy - To Buy or Renew a Virtualizor License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $ip - The IP of the license to be Purchased or Renewed
		2) $toadd - Time to extend. Valid extension e.g. 
					- '1M' will extend by one months
					- '8M' will extend by eight months
					- '1Y' will extend by One year
		5) $autorenew - To be renewed Automatically before expiry.
						Values - 1 for true
								 0 for false.
	===========================================================================*/
	
	function virt_buy($ip, $toadd, $autorenew){
		$this->params['ca'] = 'virtbuy';
		$this->params['purchase'] = 1;
		$this->params['ips'] = $ip;
		$this->params['toadd'] = $toadd;
		$this->params['autorenew'] = $autorenew;
		return $this->req();
	}
	
		
	/*===========================================================================
		@@ function virt_refund - reverses a Virtualizor transaction @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $actid - The Action ID for which you want to claim refund
		
		NOTE: A refund can be claimed only within 7 days of buying/renewing the
			  license
	===========================================================================*/
	function virt_refund($actid){
		$this->params['ca'] = 'virtrefund';
		$this->params['actid'] = $actid;
		return $this->req();
	}
		
		
	/*===========================================================================
		@@ function virt_licenses - gets a list of Virtualizor licenses @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY to get the details of that 
				  particular License
		2) $ip - (Optional) The Primary IP of a License to get the details of 
				  that particular License
		3) $expiry - (Optional) To get a List of License that are expiring.
					 Valid Options - 1 , 2 , 3 . Explanation is as follows:
					 $expiry = 1; (All Expired License in your account)
					 $expiry = 2; (Expiring in 7 Days)
					 $expiry = 3; (Expiring in 15 Days)		
		4) $start - (Optional) The starting key to return from. e.g.
					If the result is 500 licenses and you wanted only from 
					the 100th one then specify 99		
		5) $len - (Optional) The length to return from the start. e.g.
					If the result is 500 licenses and you wanted only from 
					the 200 items after the 100th one then specify 
					$start = 99 and $len = 200					
		6) $email - (Optional) The authorised email of the user for which 
					you want to get the list of licenses.
				  
		NOTE: $key, $ip, $expiry, $start, $len (i.e. All Paras) are Optional
			  When nothing is specified a list of all your license will 
			  be returned.
	===========================================================================*/
	function virt_licenses($key = '', $ip = '', $expiry = '', $start = 0, $len = 1000000, $email = ''){
		$this->params['ca'] = 'virtualizor';
		$this->params['lickey'] = $key;
		$this->params['ips'] = $ip;
		$this->params['expiry'] = $expiry;
		$this->params['start'] = $start;
		$this->params['len'] = $len;
		$this->params['email'] = $email;
		return $this->req();
	}
	
	/*===========================================================================
		@@ function virt_remove - remove Virtualizor license and its auto renewal @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY
				  
		NOTE: 1) $key needs to be specified
			  2) A cancel will not be allowed if you have a license expiring 
			  	after MORE than a MONTH.
			  3) Also a refund is not made when you cancel a license. You must 
			    first claim the refund using the refund() API			  
	===========================================================================*/
	function virt_remove($key){
		$this->params['ca'] = 'virtremove';
		$this->params['lickey'] = $key;
		$this->params['remove'] = 1;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function virt_refund_and_cancel - refund virtualizor license and then remove virtualizor license and its auto renewal @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - (Optional) The License KEY
		2) $ip - (Optional) The Primary IP of the License
				  
		NOTE: 1) Either of $ip, $key needs to be scpeified
			  2) A cancel will not be allowed if you have a license expiring 
			  	after MORE than a MONTH.
			  3) We will try to refund you if the license is purchased less than 7 days ago. And then we will cancel the license.
			  
	===========================================================================*/
	function virt_refund_and_cancel($key = '', $ip = ''){
		if(!empty($ip)){
			// Search for a license
			$lic = $this->virt_licenses('', $ip);
			// No licenes with this IP
			if(empty($lic['licenses'])){
				$this->error[] = 'No Licenses found.';
				return false;
			}
			$my_lic = current(current($lic));
			$key = $my_lic['license'];
		}
		
		// No key to search for the logs or to cancel
		if(empty($key)){
			$this->error[] = 'Please provide a License Key or a Valid IP.';
			return false;
		}
		
		// Lets get the logs
		$logs = $this->virt_licenselogs($key);
		
		// Did we get any logs ?
		if(!empty($logs['actions'])){
			foreach($logs['actions'] as $k => $v){
				// Is it a valid transaction ?
				if($v['action'] != 'renew' && $v['action'] != 'new') continue;
				// Is it purchased within last 7 days
				if((time() - $v['time'])/(24*60*60) < 7){
					$this->virt_refund($v['actid']);
				}
			}
		}
		
		// Cancel the license
		return $this->virt_remove($key);
	}
	
	
	/*===========================================================================
		@@ function virt_editips - Edit the IPs of a Virtualizor License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $lid - The License ID (NOT the license key) e.g. lid could be 1000
		2) $ips - The NEW IP of the server
				  
		NOTE: Either of $ip, $key needs to be scpeified
	===========================================================================*/
	function virt_editips($lid, $ips){
		$this->params['ca'] = 'virtlicense';
		$this->params['lid'] = $lid;
		$this->params['ips'] = $ips;
		$this->params['editlicense'] = 1;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function virt_licenselogs - Action Logs of a Virtualizor License @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY
		2) $limit - The number of action logs to be retrieved
		NOTE: The logs are returned in DESCENDING ORDER, meaning the latest logs 
			  will be return first.
	===========================================================================*/
	function virt_licenselogs($key, $limit = 0){
		$this->params['ca'] = 'virt_licenselogs';
		$this->params['key'] = $key;
		if(!empty($limit)){
			$this->params['limit'] = $limit;
		}
		return $this->req();
	}
		
		
	/*===========================================================================
		@@ function virt_renewals - List the Auto Renewing Virtualizor Licenses @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		
		1) $start - (Optional) The starting key to return from. e.g.
					If the result is 500 licenses and you wanted only from 
					the 100th one then specify 99		
		2) $len - (Optional) The length to return from the start. e.g.
					If the result is 500 licenses and you wanted only from 
					the 200 items after the 100th one then specify 
					$start = 99 and $len = 200
	===========================================================================*/
	function virt_renewals($start = 0, $len = 1000000){
		$this->params['ca'] = 'virtrenewals';
		$this->params['start'] = $start;
		$this->params['len'] = $len;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function virt_addautorenewal - Add Virtualizor Auto Renewals @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY that has to be added to Auto Renewal
	===========================================================================*/
	function virt_addautorenewal($key = ''){
		$this->params['ca'] = 'virtrenewals';
		$this->params['addrenewal'] = 1;
		$this->params['lickey'] = $key;
		return $this->req();
	}
	
	
	/*===========================================================================
		@@ function virt_removeautorenewal - Remove Virtualizor Auto Renewals @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $key - The License KEY that has to be removed from Auto Renewal
	===========================================================================*/
	function virt_removeautorenewal($key = ''){
		$this->params['ca'] = 'virtrenewals';
		$this->params['cancelrenewal'] = 1;
		$this->params['lickey'] = $key;
		return $this->req();
	}
	
		
	/*===========================================================================
		@@ function invoicedetails - Details of an invoice @@
		---------------------------------------------------------------------
		PARAMETERS :
		---------------------------------------------------------------------
		1) $invoid - The Invoice ID the details of which you want to see. If 
					 nothing is specified i.e. invoid = 0 then all unbilled 
					 transactions for the current month will be returned
	===========================================================================*/
	function invoicedetails($invoid = 0){
		$this->params['ca'] = 'invoicedetails';
		$this->params['invoid'] = $invoid;
		return $this->req();
	}
	
	
	function r($r){
		if(empty($r)){
			$r = $this->error;
		}
		echo '<pre>';print_r($r);echo '</pre>';
	}
	
}

/*

////////////////////////
// SOFTACULOUS Examples
////////////////////////

// Initiate the class with your NOC Account Credentials
$noc = new SOFT_NOC('username', 'password');

// Buy / renew a License
$noc->r($noc->buy('174.37.113.98', '1M', 1, 'test@test.com', 1));

// Refund a Transaction
$noc->r($noc->refund(100));

// Refund a Transaction and then cancel license
$noc->r($noc->refund_and_cancel('88888-88888-88888-88888-88888'));

// Refund a Transaction and then cancel license by IP
$noc->r($noc->refund_and_cancel('', '198.198.198.198'));

// Get me all my licenses
$noc->r($noc->licenses());
// Search for a license by IP
$noc->r($noc->licenses('', '198.198.198.198'));
// Search for a license by KEY
$noc->r($noc->licenses('88888-88888-88888-88888-88888'));
// All Expired Licenses
$noc->r($noc->licenses('', '', 1));
// Expiring in next 7 Days
$noc->r($noc->licenses('', '', 2));
// Expiring in next 15 Days
$noc->r($noc->licenses('', '', 3));

// Cancel a License
$noc->r($noc->cancel('88888-88888-88888-88888-88888')); // Cancel by License Key
$noc->r($noc->cancel('', '198.198.198.198')); // Cancel by IP

// EDIT IP of a License
$noc->r($noc->editips(1000, '198.198.198.198')); // LID and new IP Address

// Get the Action/Activity Logs of a License
$noc->r($noc->licenselogs('88888-88888-88888-88888-88888'));

// Get me all auto renewing Licenses
$noc->r($noc->autorenewals());

// Start auto renewing a license
$noc->r($noc->addautorenewal('88888-88888-88888-88888-88888'));

// Stop auto renewing a license
$noc->r($noc->removeautorenewal('88888-88888-88888-88888-88888'));

*/

/*

////////////////////
// WEBUZO Examples
////////////////////

// Initiate the class with your NOC Account Credentials 
$noc = new SOFT_NOC('username', 'password');

// Buy / renew a License
$noc->r($noc->webuzo_buy('174.37.113.98', '1M', 1, 'test@test.com', 1));

// Refund a Transaction
$noc->r($noc->webuzo_refund(100));

// Refund a Transaction and then cancel webuzo license
$noc->r($noc->webuzo_refund_and_cancel('88888-88888-88888-88888-88888'));

// Refund a Transaction and then cancel webuzo license by IP
$noc->r($noc->webuzo_refund_and_cancel('', '198.198.198.198'));

// Get me all my licenses
$noc->r($noc->webuzo_licenses());
// Search for a license by IP
$noc->r($noc->webuzo_licenses('', '198.198.198.198'));
// Search for a license by KEY
$noc->r($noc->webuzo_licenses('webuzo-88888-88888-88888-88888'));
// All Expired Licenses
$noc->r($noc->webuzo_licenses('', '', 1));
// Expiring in next 7 Days
$noc->r($noc->webuzo_licenses('', '', 2));
// Expiring in next 15 Days
$noc->r($noc->webuzo_licenses('', '', 3));

// Cancel a License
$noc->r($noc->webuzo_cancel('webuzo-88888-88888-88888-88888')); // Cancel by License Key
$noc->r($noc->webuzo_cancel('', '198.198.198.198')); // Cancel by IP

// EDIT IP of a License
$noc->r($noc->webuzo_editips(1000, '198.198.198.198')); // LID and new IP Address

// Get the Action/Activity Logs of a License
$noc->r($noc->webuzo_licenselogs('webuzo-88888-88888-88888-88888'));

// Get me all auto renewing Licenses
$noc->r($noc->webuzo_autorenewals());

// Start auto renewing a license
$noc->r($noc->webuzo_addautorenewal('webuzo-88888-88888-88888-88888'));

// Stop auto renewing a license
$noc->r($noc->webuzo_removeautorenewal('webuzo-88888-88888-88888-88888'));

// Get a Trial license
$noc->r($noc->webuzotrial('198.198.198.198', 1));

*/

/*
////////////////////////
// VIRTUALIZOR Examples
////////////////////////

// Buy / renew a License
$noc->r($noc->virt_buy('198.198.198.198', '1M', 1));

// Refund a Transaction
$noc->r($noc->virt_refund(100));

// Refund a Transaction and then cancel Virtualizor license
$noc->r($noc->virt_refund_and_cancel('88888-88888-88888-88888-88888'));

// Refund a Transaction and then cancel Virtualizor license by IP
$noc->r($noc->virt_refund_and_cancel('', '198.198.198.198'));

// Get me all my licenses
$noc->r($noc->virt_licenses());
// Search for a license by IP
$noc->r($noc->virt_licenses('', '198.198.198.198'));
// Search for a license by KEY
$noc->r($noc->virt_licenses('88888-88888-88888-88888-88888'));
// All Expired Licenses
$noc->r($noc->virt_licenses('', '', 1));
// Expiring in next 7 Days
$noc->r($noc->virt_licenses('', '', 2));
// Expiring in next 15 Days
$noc->r($noc->virt_licenses('', '', 3));

// Cancel a License
$noc->r($noc->virt_remove('88888-88888-88888-88888-88888')); // Remove by License Key

// Edit the IP of a license
$noc->r($noc->virt_editips(1, '111.111.111.111'));

// Get the Action/Activity Logs of a License
$noc->r($noc->virt_licenselogs('88888-88888-88888-88888-88888'));

// Get me all auto renewing Licenses
$noc->r($noc->virt_renewals());

// Start auto renewing a license
$noc->r($noc->virt_addautorenewal('88888-88888-88888-88888-88888'));

// Stop auto renewing a license
$noc->r($noc->virt_removeautorenewal('88888-88888-88888-88888-88888'));

*/

/*

////////////////////
// INVOICE Details
////////////////////

// Get all transactions of a Invoice
$noc->r($noc->invoicedetails(100));
// Get all unbilled transactions for the current month
$noc->r($noc->invoicedetails());

*/

/*

////////////////////
// ERROR Handling
////////////////////

// After any query, the class variable 'error' will be filled up IF there was an error

$noc = new SOFT_NOC('username', 'password');

// Buy / renew a License
$result = $noc->webuzo_buy('174.37.113.98', '1M', 1, 'test@test.com', 1);

// Check for any error
if(empty($noc->error)){
	// Everything went perfect
}else{
	// Dump the error
	print_r($noc->error);
}

*/

?>